/*
 * Decompiled with CFR 0.152.
 */
import java.util.UUID;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;

public class matchbook_generator
extends PApplet {
    PFont font_token;
    PGraphics front_panel;
    PGraphics back_panel;
    PGraphics front_sheet;
    PGraphics back_sheet;
    PGraphics page;
    String book_token;
    String origin_code = null;

    public void setup() {
        matchbook_generator.println((String)"Ghost Agency's matchbook generator v1.0");
        if (this.args != null) {
            this.origin_code = this.args[0];
        }
        matchbook_generator.println((String)"Creating...");
        this.font_token = this.loadFont("Monospaced.plain-62.vlw");
        this.book_token = this.genNMC(this.origin_code);
        this.front_panel = this.setFrontPanel(this.book_token);
        this.back_panel = this.setBackPanel(this.book_token);
        this.front_sheet = this.setSheet(this.front_panel);
        this.back_sheet = this.setSheet(this.back_panel);
        matchbook_generator.println((String)"Saving!");
        this.front_sheet.save("playbook-" + this.book_token + "(f).png");
        this.back_sheet.save("playbook-" + this.book_token + "(b).png");
        matchbook_generator.println((String)"Finished!");
        this.exit();
    }

    public PGraphics setSheet(PGraphics panel) {
        PGraphics sheet = this.createGraphics(2550, 3300);
        sheet.beginDraw();
        sheet.smooth();
        sheet.image((PImage)panel, 0.0f, 0.0f, (float)sheet.width, (float)(sheet.height / 2));
        sheet.image((PImage)panel, 0.0f, (float)(sheet.height / 2), (float)sheet.width, (float)(sheet.height / 2));
        sheet.endDraw();
        return sheet;
    }

    public PGraphics setFrontPanel(String book_token) {
        PGraphics front_panel = this.createGraphics(2550, 1650);
        front_panel.beginDraw();
        front_panel.smooth();
        this.page = this.createPage('5', book_token);
        this.setPage(front_panel, this.page, 0, 0, false);
        this.page = this.createPage('A', book_token);
        this.setPage(front_panel, this.page, 637, 0, false);
        this.page = this.createPage('9', book_token);
        this.setPage(front_panel, this.page, 1274, 0, false);
        this.page = this.createPage('6', book_token);
        this.setPage(front_panel, this.page, 1912, 0, false);
        this.page = this.createPage('2', book_token);
        this.setPage(front_panel, this.page, 637, 1650, true);
        this.page = this.createPage('D', book_token);
        this.setPage(front_panel, this.page, 1274, 1650, true);
        this.page = this.createPage('E', book_token);
        this.setPage(front_panel, this.page, 1912, 1650, true);
        this.page = this.createPage('1', book_token);
        this.setPage(front_panel, this.page, 2550, 1650, true);
        front_panel.endDraw();
        return front_panel;
    }

    public PGraphics setBackPanel(String book_token) {
        PGraphics back_panel = this.createGraphics(2550, 1650);
        back_panel.beginDraw();
        back_panel.smooth();
        this.page = this.createPage('7', book_token);
        this.setPage(back_panel, this.page, 0, 0, false);
        this.page = this.createPage('8', book_token);
        this.setPage(back_panel, this.page, 637, 0, false);
        this.page = this.createPage('B', book_token);
        this.setPage(back_panel, this.page, 1274, 0, false);
        this.page = this.createPage('4', book_token);
        this.setPage(back_panel, this.page, 1912, 0, false);
        this.page = this.createPage('C', book_token);
        this.setPage(back_panel, this.page, 1912, 1650, true);
        this.page = this.createPage('3', book_token);
        this.setPage(back_panel, this.page, 2550, 1650, true);
        back_panel.endDraw();
        return back_panel;
    }

    public void setPage(PGraphics sheet, PGraphics page, int x, int y, boolean rotated) {
        sheet.pushMatrix();
        sheet.translate((float)x, (float)y);
        if (rotated) {
            sheet.rotate(matchbook_generator.radians((float)180.0f));
        }
        sheet.image((PImage)page, 0.0f, 0.0f);
        sheet.popMatrix();
    }

    public PGraphics createPage(char page_id, String book_token) {
        PGraphics page = this.createGraphics(637, 825);
        page.beginDraw();
        page.smooth();
        page.background(255);
        page.stroke(0);
        page.noFill();
        page.rect(0.0f, 0.0f, (float)(page.width - 1), (float)(page.height - 1));
        page.strokeWeight(3.0f);
        page.rect(40.0f, 30.0f, (float)(page.width - 80), (float)(page.height - 132));
        page.noStroke();
        page.fill(0);
        page.textFont(this.font_token);
        page.textSize(62.0f);
        page.textAlign(3, 101);
        int i = 0;
        while (i < 8) {
            String token = String.valueOf(String.format("%02d", i + 1)) + " " + this.genNMC(null);
            page.text(token, (float)(page.width / 2), (float)(66 + i * 82));
            ++i;
        }
        page.textAlign(37, 101);
        page.text(book_token, 40.0f, (float)(page.height - 80));
        page.textAlign(39, 101);
        page.text(page_id, (float)(page.width - 40), (float)(this.height - 80));
        page.endDraw();
        return page;
    }

    public String genNMC(String origin_code) {
        String token = null;
        if (origin_code != null) {
            byte[] bytes = origin_code.getBytes();
            token = UUID.nameUUIDFromBytes(bytes).toString();
        } else {
            token = UUID.randomUUID().toString();
        }
        return String.copyValueOf(token.toCharArray(), 9, 9).toUpperCase();
    }

    public void settings() {
        this.size(320, 412);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"matchbook_generator"};
        if (passedArgs != null) {
            PApplet.main((String[])matchbook_generator.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

